<?php
/**
 * Test Service - Untuk test apakah service bekerja
 * Akses: http://localhost/amf_gateway/test_service.php
 */

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


require_once 'config.php';
require_once 'db.php';
require_once 'services/SystemService.php';

header('Content-Type: application/json');

try {
    $db = getDBConnection();
    $service = new SystemService($db);
    
    // Test login
    $result = $service->login('test', 'test123', '3.3.008');
    
    echo json_encode([
        'status' => 'success',
        'message' => 'Service is working!',
        'result' => $result
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ], JSON_PRETTY_PRINT);
}
?>

