<?php
/**
 * Debug AMF Request
 * Untuk melihat format request dari Flash client
 */

require_once 'vendor/autoload.php';

use SabreAMF\AMF;
use SabreAMF\AMF3\Deserializer;

header('Content-Type: text/plain');

$input = file_get_contents('php://input');

echo "=== AMF Request Debug ===\n\n";
echo "Input length: " . strlen($input) . " bytes\n";
echo "First 20 bytes (hex): " . bin2hex(substr($input, 0, 20)) . "\n\n";

if (strlen($input) > 0) {
    try {
        $amf = new AMF();
        $amf->setDeserializer(new Deserializer());
        $request = $amf->deserialize($input);
        
        echo "Deserialize: SUCCESS\n\n";
        echo "Request type: " . gettype($request) . "\n";
        
        if (is_object($request)) {
            echo "Request class: " . get_class($request) . "\n";
            echo "Properties:\n";
            foreach (get_object_vars($request) as $key => $value) {
                echo "  - $key: " . gettype($value);
                if (is_array($value)) {
                    echo " (array with " . count($value) . " items)";
                }
                echo "\n";
            }
        } else {
            echo "Request value: " . print_r($request, true) . "\n";
        }
    } catch (Exception $e) {
        echo "Deserialize: FAILED\n";
        echo "Error: " . $e->getMessage() . "\n";
        echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
    }
} else {
    echo "No input received\n";
}
?>

